define(['angular', 'app'], function (angular, app, Highcharts) {
    'use strict';

    app.service('GoalHistoryGraphService', function ($filter, FitnessConstants) {


        var service = {};

        service.chartConfig = {
            options: {
                chart: {
                    type: 'column',
                    borderColor: '#EBBA95',
                    borderWidth: 2,
                    borderRadius: 3,
                    zoomType: 'none',
					pinchType: 'none',
                    marginBottom: 120,
                    height: 500
                },
                colors: ['#ec3636','#65899b','#ffffff'],
                legend: {
                    align: 'right',
                    x: -10,
                    verticalAlign: 'bottom',
                    floating: true,
                    //backgroundColor: (Highcharts.theme && Highcharts.theme.background2) || 'white',
                    borderColor: '#CCC',
                    borderWidth: 1,
                    shadow: true
                },
                plotOptions: {
                    series: {                            
                        events: {
                            legendItemClick: function () {
                                return false;
                            }
                        },
                        threshold:0
                    },
                    column : {
                        stacking : null,
                        groupPadding : 0,
                        borderWidth:0
                        
                    }
                }
            },
            useHighStocks: false,
            credits: { enabled: false },
            loading: false
        };

        service.getGraphConfig = function(filter) {



            var graphConfig = {
                minutes: angular.copy(service.chartConfig),
                steps:   angular.copy(service.chartConfig),
                miles:   angular.copy(service.chartConfig)
            };

            var selectedDateFilter = filter.service.dataPointers.filters;

            selectedDateFilter = filter;


            for(var item in graphConfig) {


                graphConfig[item].yAxis  = getYaxisConfig(item);
                graphConfig[item].xAxis  = getXaxisConfig(selectedDateFilter);
                graphConfig[item].series = getSeriesConfig(item, filter);
                graphConfig[item].title  = getTitleConfig(item, selectedDateFilter);
                graphConfig[item].options.tooltip = getTooltipConfig(item);
            }

            return graphConfig;
        };

        var getTooltipConfig = function(item) {
            return {
                formatter: function () {
                    var date = '<b>' + Highcharts.dateFormat('%m/%d/%Y', this.x) + '</b><br/>';
                    var numDecimals = item === 'miles' ? 1 : 0;

                    return 'Week of ' + date + this.series.name + ': ' + $filter('number')(this.y, numDecimals) + ' ' + item ;
                }
            };
        };

        var getTitleConfig = function(item, filter) {


                if (item==='miles') {
                        return {text: 'Miles Activity and Goals from ' + filter.startDate + ' to ' + filter.endDate};
                } else if (item==='minutes') {
                        return {text: 'Minutes Activity and Goals from ' + filter.startDate + ' to ' + filter.endDate};
                } else {
                        return {text: 'Steps Activity and Goals from ' + filter.startDate + ' to ' + filter.endDate};
                }
        };

        var getSeriesConfig = function(item, filter) {



            var points = filter.service.dataPointers.list;
            if (!points || points.length === 0) {
                return [];
            }
            var chartSeries = [];
            var tmpSeries = {
                        'Goal' : [],
                        'Activity' : [],
                        'zero' : []
                };

            angular.forEach(angular.copy(points).reverse(), function (point, pointIndex) {
                    if (point.units===item) {
                        var goalDate = new Date(point.goalDateTime),
                            goalDateUTC = Date.UTC(
                                parseInt($filter('date')(goalDate, 'yyyy')),
                                parseInt($filter('date')(goalDate, 'MM')) - 1,
                                parseInt($filter('date')(goalDate, 'dd'))
                            );
                        tmpSeries['Goal'].push([goalDateUTC, point.goal]);
                        tmpSeries['Activity'].push([goalDateUTC, point.achieved]);
                    }
            });

            var selectedDateFilter = filter.service.dataPointers.filters;
            fillTmpSeriesWithZeroDataPoints(tmpSeries, selectedDateFilter);

            chartSeries.push({name: 'Activity',data:tmpSeries['Activity'],showInLegend:true,events:{legendItemClick:function(){return false;}}});
            chartSeries.push({name: 'Goal',data:tmpSeries['Goal'],showInLegend:true,events:{legendItemClick:function(){return false;}}});
            
            return chartSeries;
        };

        var fillTmpSeriesWithZeroDataPoints = function(tmpSeries, filter) {
            var filterDatesUTC = getFilterDatesUTC(filter),
                startDateUTC = filterDatesUTC.startDateUTC,
                endDateUTC   = filterDatesUTC.endDateUTC,
                msInDay = 3600000 * 24;

            for(var i=startDateUTC; i<endDateUTC; i+=msInDay) {
                tmpSeries.zero.push([i, 0]);
            }
        };

        var getFilterDatesUTC = function(filter) {


            var startDate = new Date(filter.startDate),
                endDate = new Date(filter.endDate),
                startDateUTC = Date.UTC(
                    parseInt($filter('date')(startDate, 'yyyy')),
                    parseInt($filter('date')(startDate, 'MM')) - 1,
                    parseInt($filter('date')(startDate, 'dd')),
                    0, 0
                ),
                endDateUTC = Date.UTC(
                    parseInt($filter('date')(endDate, 'yyyy')),
                    parseInt($filter('date')(endDate, 'MM')) - 1,
                    parseInt($filter('date')(endDate, 'dd')) + 1,
                    0, 0
                );

            return {
                startDateUTC: startDateUTC,
                endDateUTC:   endDateUTC
            };
        };

        var getXaxisConfig = function(filter) {

            var filterDatesUTC = getFilterDatesUTC(filter);

            return {
                type: 'datetime',
                dateTimeLabelFormats: {
                    millisecond: '%b %e %I:%M %p',
                    second: '%b %e %I:%M %p',
                    minute: '%b %e %I:%M %p',
                    hour: '%b %e %I:%M %p',
                    day: '%b %e',
                    week: '%b %e',
                    month: '%b %Y',
                    year: '%Y'
                },
                minRange: 24 * 3600000,
                minTickInterval: 3600000,
                min: filterDatesUTC.startDateUTC,
                max: filterDatesUTC.endDateUTC,
                title: {
                    text: 'Date', style: {'font-weight': 'bold', 'color': 'black', 'font-size': '14px'}
                }
            };
        };

        var getYaxisConfig = function(item) {
            return {
                title: {text: initCap(item), style: {'font-weight': 'bold', 'color': 'black', 'font-size': '14px'}}
            };
        };

        function initCap(word) {
            return word.substring(0,1).toUpperCase() + word.substring(1,word.length).toLowerCase();
        }

        return service;
    });
});